const express = require('express');
const tencentcloud = require('tencentcloud-sdk-nodejs');
const app = express();

// 下方填入四个必填字段
const config = {
  // 请预先确认是否已经创建过智能客服实例(应用)，创建成功后在智能客服管理端可看到智能客服SDKAppID
  sdkAppId: '',
  // 此即购买的(赠送的)座席账号
  userId: '',
  // secretId及secretKey在访问管理页面获取：https://console.cloud.tencent.com/cam/capi
  secretId: '',
  secretKey: ''
};

const iniCheck = () => config.sdkAppId && config.userId && config.secretId && config.secretKey;

app.use('/loginTCCC', (req, res) => {
  const { sdkAppId, userId, secretId, secretKey } = config;
  const CccClient = tencentcloud.ccc.v20200210.Client;
  const clientConfig = {
    credential: {
      secretId,
      secretKey,
    },
    region: '',
    profile: {
      httpProfile: {
        endpoint: 'ccc.tencentcloudapi.com',
      },
    }
  };
  const client = new CccClient(clientConfig);
  const params = {
    SdkAppId: +sdkAppId,
    SeatUserId: userId,
  };
  client.CreateSDKLoginToken(params).then(
    (data) => {
      res.send({
        token: data.Token,
        sdkUrl: data.SdkURL,
        sdkAppId,
        userId
      });
    },
    (err) => {
      console.log('\x1b[41m 获取Token失败：', err);
      if (iniCheck()) {
        res.send({
          errMsg: err.message,
          code: err.code,
        });
      } else {
        res.send({
          errMsg: '初始化失败',
          code: err.code,
          type: 'NotInitialized',
        });
      }
    }
  );
});

app.listen(4000, () => {
  console.log('\x1b[42m API Server run success on port 4000');
});