import { useEffect, useState } from 'react';
import './App.scss';
import { Tabs } from './components/tabs/Tab';
import { styles } from './styles';
const arrowImg = 'https://tccc.qcloud.com/assets/arrow.png';

const statusMap = {
  offline: '已下线',
  disconnect: '网络断开，重连中',
  free: '空闲中',
  busy: '忙碌中',
  rest: '小休中',
  countdown: '话后倒计时',
  arrange: '话后整理中',
  notReady: '示忙中',
};

const errorFieldMap = {
  'InvalidParameterValue.InstanceNotExist': 'sdkAppId',
  'InvalidParameterValue.AccountNotExist': 'userId',
  'AuthFailure.SignatureFailure': 'secretKey或secretId',
  'AuthFailure.SecretIdNotFound': 'secretId',
};

function App() {
  const [seat, setSeat] = useState('');
  const [status, setStatus] = useState('');
  const [number, setNumber] = useState('');
  const [loading, setLoading] = useState(false);
  const [isError, setIsError] = useState(false);
  const [errorField, setErrorField] = useState('');
  const [active, setActive] = useState(0);

  const injectTCCC = ({ token, sdkAppId, userId, sdkUrl }) => {
    const scriptDom = document.createElement('script');
    scriptDom.setAttribute('crossorigin', 'anonymous');
    scriptDom.dataset.token = token;
    scriptDom.dataset.sdkAppId = sdkAppId;
    scriptDom.dataset.userid = userId;
    scriptDom.src = sdkUrl;
    document.body.appendChild(scriptDom);
    scriptDom.addEventListener('load', () => {
      // ready事件必须监听，否则容易发生tccc不存在的错误，所有呼入呼出的逻辑必须在ready事件触发后才可以调用
      window.tccc.on('ready', () => {
        // 以下为Demo逻辑，非业务必须。业务代码主要实现都在这个部分
        const status = window.tccc.Agent.getStatus();
        setStatus(status);
        setSeat(userId);
      });
      // 以下为Demo逻辑，非接入必须
      setInterval(() => {
        const status = window.tccc.Agent.getStatus();
        setStatus(status);
      }, 200);
    });
  };

  useEffect(() => {
    // 获取Token的方法必须在页面初始化时第一优先级调用
    fetch('/loginTCCC')
      .then((res) => res.json())
      .then((res) => {
        // 以下为Demo逻辑，需要替换为业务逻辑
        if (res.code) {
          if (res.type) {
            setIsError(true);
            setErrorField(errorFieldMap[res.code]);
          } else {
            setIsError(true);
            if (errorFieldMap[res.code]) {
              setErrorField(errorFieldMap[res.code]);
            } else {
              alert(res.errMsg);
            }
            return;
          }
        }
        // 调用成功后才可以开始执行TCCC的注入
        injectTCCC({
          token: res.token,
          userId: res.userId,
          sdkUrl: res.sdkUrl,
          sdkAppId: res.sdkAppId,
        });
      })
      .catch((error) => {
        console.error(`获取Token失败：${error.message}`);
      });
  }, []);

  const handleCallout = async () => {
    if (loading) {
      return;
    }
    setLoading(true);
    // 调用呼出方法的核心代码
    try {
      await window.tccc.Call.startOutboundCall({ phoneNumber: number });
    } catch (error) {
      console.error(`呼出失败：${error.message}`);
    } finally {
      setLoading(false);
    }
  };

  // Demo逻辑，业务侧不需要关注
  const renderGlobalError = () => 
    <div style={styles.globalErrorContainer}>
      <div style={styles.subTitle1}>{errorField}参数配置错误，请在server/dev.js文件中配置正确的参数</div>
      <div style={styles.listItem}>sdkAppId：您创建的应用ID，登录<a style={styles.link}  target="_blank" href="https://desk.qcloud.com/login" rel="noreferrer">智能客服管理端</a>即可查看（可参考<a className="link" target="_blank" href='https://cloud.tencent.com/document/product/269/96059'
        rel="noreferrer">《快速入门》</a> 进行登录)</div>
      <img src="https://qcloudimg.tencent-cloud.cn/image/document/2a842497b4c9c529667ccd69fe3d8cb3.png"
        style={{width:'600px', height:'300px'}}></img>
      <div style={styles.listItem}>userId: 座席账号，通常为邮箱格式，可以在<a style={styles.link} target="_blank" href="https://cloud.tencent.com/document/product/269/97450" rel="noreferrer">管理端-团队管理</a>进行查看（可参考<a style={styles.link}  target="_blank" href='https://cloud.tencent.com/document/product/269/96059' rel="noreferrer">《快速入门》</a> 进行登录)</div>
      <div style={styles.listItem}>secretId和secretKey：开发者调用云 ApI 所需凭证，通过<a style={styles.link}  target="_blank" href="http://console.cloud.tencent.com/cam/capi" rel="noreferrer">腾讯云控制台</a>创建。</div>
      <div style={styles.listBottom} >详细说明可以参考文档<a style={styles.link}  target="_blank" href='https://cloud.tencent.com/document/product/269/97817' rel="noreferrer">《初始化SDK》</a></div>
    </div>;
  const items = [{
    label: '电话客服',
    children: (
      <>
        <section style={styles.section}>
          <div style={styles.subTitle}>拨打电话</div>
          <div style={styles.text}>
          参考
            <a style={styles.link} target="_blank" href='https://cloud.tencent.com/document/product/679/84670' rel="noreferrer">《配置电话呼出》</a>配置后，可在此拨打电话：
          </div>
          <div>
            <input style={styles.input} value={number} placeholder="请输入电话号码" onChange={(e) => setNumber(e.target.value)} />
            <button style={styles.button} onClick={handleCallout}>拨打</button>
          </div>
        </section>
        <section style={styles.section}>
          <div style={styles.subTitle}>接听电话</div>
          <div style={styles.text}>
            参考
            <a style={styles.link} target="_blank" href='https://cloud.tencent.com/document/product/679/84671' rel="noreferrer">《配置电话呼入》</a>配置后，拨打您的号码，在该Demo页可以进行接听
          </div>
        </section>
        <section style={styles.section}>
          <div style={styles.subTitle}>座席状态</div>
          <div style={styles.list}>账号：{seat || '加载中...'}</div>
          <div style={styles.list}>状态：{statusMap[status] || '加载中...'}</div>
        </section>
      </>
    )
  }, {
    label: '在线客服',
    children: (<>
      <section style={styles.section}>
        <div style={styles.subTitle}>打开用户端</div>
        <div style={styles.list}>参考 <a href="https://cloud.tencent.com/document/product/269/118343" target="_blank" rel="noopener noreferrer">《网页 / H5 配置》</a>配置后，在管理端打开用户端链接</div>
        <img src="https://qcloudimg.tencent-cloud.cn/image/document/9f9688e0a739f3e5126e2dc946764fc9.png" style={{width:'600px', height:'400px'}} alt="" />
      </section>
      <section style={styles.section}>
        <div style={styles.subTitle}>将工作台嵌入页面</div>
        <div style={styles.list}>除了用右下角浮层方式打开工作台，还可以将工作台嵌入任意DOM元素中</div>
      </section>
    </>)
  }, {
    label: '音视频客服',
    children: (<>
      <section style={styles.section}>
        <div style={styles.subTitle}>配置并使用</div>
        <div style={styles.list}>参考文档 <a href="https://cloud.tencent.com/document/product/679/84673" target="_blank" rel="noopener noreferrer">《配置音频客服》</a>、<a href="https://cloud.tencent.com/document/product/679/84674" target="_blank" rel="noopener noreferrer">《配置视频客服》</a>进行配置</div>
        <div style={styles.list}>打开用户端和坐席进行通话</div>
      </section>
    </>)
  }];
  
  // Demo逻辑，业务侧不需要关注
  return (
    <div style={styles.container} className='sdk-demo'>
      <div style={styles.title}>
        智能客服座席端SDK
      </div>
      {isError ? renderGlobalError() :
        <>
          <Tabs items={items} activeId={active} onActive={setActive}/>
          <section style={styles.section}>
          在线客服客服有问题可进入<a style={{ color: '#10a37f' }} href="https://desk.qcloud.com/assets/support-CVQd9e_B.png" target="_blank" rel="noreferrer">IM智能客服交流群</a>咨询。
          </section>
          <section style={styles.section}>
          电话客服/音视频客服有问题可进入<a style={{ color: '#10a37f' }} href="https://zhiliao.qq.com/s/cHBOFIIM62C6" target="_blank" rel="noreferrer">TCCC 社群</a>咨询。
            <div style={{marginTop: '1em'}}>坐席端 SDK 文档：<a style={{ color: '#10a37f' }} href="https://cloud.tencent.com/document/product/679/72044" target="_blank" rel="noreferrer">https://cloud.tencent.com/document/product/679/72044</a></div>
          </section>
          <section style={styles.bottomSection}>
            <div style={styles.clickHint}>点击此处打开工作台</div>
            <img width={235} height={235} src={arrowImg} />
          </section>
        </>
      }
    </div>
  );
}

export default App;
