import './Tab.scss';

export function Tabs({activeId = 0, onActive, items = []}) {
  return (
    <>
      <div className="tabs">
        {items.map((item, idx) =>
          (
            <div
              onClick={() => onActive(idx)}
              key={idx}
              className={`tab ${idx === activeId ? 'active' : ''}`}
            >{item.label}
            </div>
          )
        )}
      </div>
      {items[activeId].children}
    </>
  );
}