# 智能客服 VUE demo

```
.
├── README.md
├── index.html
├── package-lock.json
├── package.json
├── server
│   └── dev.js         --服务端代码实现，包含云API请求代码，开发用
├── src                --前端页面目录
│   ├── App.vue
│   ├── Container.vue
│   └── main.js
└── vite.config.js     --项目Vite配置，包括页面的请求代理转发到服务端
```

## 前提条件

1. 您已注册腾讯云账号，并完成企业认证
2. 登录[控制台智能客服页面](https://console.cloud.tencent.com/im/ai-desk)，创建新应用

## 操作步骤

### 步骤 2：配置 demo 文件

1. 找到并打开`server/dev.js`文件
2. 设置相关参数

- SecretId、SecretKey: [在此处获取](https://console.cloud.tencent.com/cam/capi)

### 步骤三：运行项目

> ⚠️ 注意：  
> 建议 node 环境为 v14.17.3 ~ v16.15.0。如遇到node版本18报错，尝试降级到建议版本，或者执行npm audit fix --force后重启项目。

[点击下载 node](https://nodejs.dev/)

#### 1. 安装依赖

```bash
npm install
```

#### 2. 运行开发

```bash
npm run dev
```

使用 Chrome 或 Edge 浏览器打开`http://localhost:5173/`

> ⚠️ 特别注意：  
> 服务端代码实现只是使用Node.js调用腾讯云的Node.jsSDK实现了一个简单的loginTCCC接口，接入方在接入时需要使用其他腾讯云支持的后端技术栈自行实现这个接口以获取必要信息。